<?php
/*
Plugin Name: 搜索限制
Description: 限制搜索词长度和搜索频率，防止搜索功能被滥用。
Version: 1.0
Author: THEMEPARK
Author URI: https://www.themepark.com.cn
Plugin URI: https://www.themepark.com.cn
*/


// 设置搜索词的最大长度
const MAX_SEARCH_TERM_LENGTH = 30;//字符长度
// 每分钟允许的最大搜索次数
const SEARCH_LIMIT_COUNT = 5;//次数
// 超出后限制时间（秒）
const SEARCH_COOLDOWN_INTERVAL = 300; // 5 分钟

// 限制搜索词的长度
add_filter('posts_search', 'limit_search_term_length', 10, 2);
function limit_search_term_length($search, $wp_query) {
    if (!is_admin() && $wp_query->is_search()) {
        $search_query = isset($_GET['s']) ? sanitize_text_field($_GET['s']) : '';

        if (strlen($search_query) > MAX_SEARCH_TERM_LENGTH) {
            wp_die(__('搜索词太长，请缩短搜索词后重试。', 'limit-search-abuse'));
        }
    }
    return $search;
}

// 限制搜索频率
add_action('parse_query', 'limit_search_frequency');
function limit_search_frequency($query) {
    if (!is_admin() && $query->is_search()) {
        // 获取用户 IP 地址
        $user_ip = $_SERVER['REMOTE_ADDR'];
        $transient_key = 'search_limit_' . md5($user_ip);

        // 检查是否已有搜索记录
        $search_data = get_transient($transient_key);

        if ($search_data !== false) {
            $search_data = json_decode($search_data, true);
            $current_time = time();

            // 如果在冷却时间内
            if (isset($search_data['cooldown']) && $current_time < $search_data['cooldown']) {
                $wait_time = ceil(($search_data['cooldown'] - $current_time) / 60);
                wp_die(sprintf(__('搜索过于频繁，请等待 %d 分钟后重试。', 'limit-search-abuse'), $wait_time));
            }

            // 如果在一分钟内的搜索次数超限
            if ($current_time - $search_data['start_time'] <= 60) {
                if ($search_data['count'] >= SEARCH_LIMIT_COUNT) {
                    $search_data['cooldown'] = $current_time + SEARCH_COOLDOWN_INTERVAL;
                    set_transient($transient_key, json_encode($search_data), SEARCH_COOLDOWN_INTERVAL);
                    wp_die(sprintf(__('搜索过于频繁，请等待 %d 分钟后重试。', 'limit-search-abuse'), ceil(SEARCH_COOLDOWN_INTERVAL / 60)));
                }

                $search_data['count']++;
            } else {
                // 超过一分钟，重置计数器
                $search_data['start_time'] = $current_time;
                $search_data['count'] = 1;
            }
        } else {
            // 初始化搜索数据
            $search_data = [
                'start_time' => time(),
                'count' => 1
            ];
        }

        set_transient($transient_key, json_encode($search_data), 60);
    }
}
